/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Date First Issued  : 10/25/2004
* Description        : The main program
********************************************************************************
* History:
*  15/09/2006 : IAP Version 3.0
*  02/01/2006 : IAP Version 2.0
*  11/24/2004 : IAP Version 1.0
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "common.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
static u8 Push_Button_Read (void);
static void Push_Button_Config(void);


/* Private functions ---------------------------------------------------------*/
/*******************************************************************************
* Function Name  : IAP_Init
* Description    : Initialize the IAP(Configure PLL, UART and GPIOs).
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void IAP_Init(void)
{

    /* Set Main Freq to 32MHz */
    RCCU_Div2Config(ENABLE);
    RCCU_PLL1Config(RCCU_PLL1_Mul_12, RCCU_Div_3);
    /* Wait PLL to lock */
    while (RCCU_FlagStatus(RCCU_PLL1_LOCK) == RESET);
    /* Select the PLL1 as clock source */
    RCCU_RCLKSourceConfig(RCCU_PLL1_Output);

    /* Configure the GPIO0 pins */
    GPIO_Config(GPIO0, 0x100, GPIO_IN_TRI_CMOS);
    GPIO_Config(GPIO0, 0x200, GPIO_AF_PP);

    /* UART0 configured as follow:
          - Baudrate = 115200Bps
          - No parity 
          - 8 data bits 
          - 1 stop bit  
    */
    UART_OnOffConfig(UART0, ENABLE);
    UART_FifoConfig (UART0, DISABLE);
    UART_FifoReset(UART0 , UART_RxFIFO);
    UART_FifoReset(UART0 , UART_TxFIFO);
    UART_LoopBackConfig(UART0 , DISABLE);

    UART_Config(UART0, 115200, UART_NO_PARITY, UART_1_StopBits, UARTM_8D);
    UART_RxConfig(UART0 , ENABLE);
}

/*******************************************************************************
* Function Name  : Push_Button_Read
* Description    : Read the port pin (connected to the push button) level.
* Input          : None
* Output         : None
* Return         : The port pin level (SET or RESET).
*******************************************************************************/
static u8 Push_Button_Read (void)
{
    /* Return the status of the P1.8 pin = "SEL" button on the STR710-EVAL */
    return GPIO_BitRead(GPIO1, 8);
}

/*******************************************************************************
* Function Name  : Push_Button_Config
* Description    : Configures the port pin connected to the push button.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
static void Push_Button_Config(void)
{

    /* P1.8 configuration */
    GPIO_Config(GPIO1, 0x0100, GPIO_IN_TRI_CMOS);
}

/*******************************************************************************
* Function Name  : main
* Description    : Main program.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void main(void)
{
    pFunction Jump_To_Application;

#ifdef DEBUG
    debug();
#endif

    Push_Button_Config();


    if (!(Push_Button_Read()))       /* If SEL is pressed */
    {
        /* Execute the IAP driver in order to re-program the Flash */
        IAP_Init();
        SerialPutString("\r\n======================================================================");
        SerialPutString("\r\n=              (C) Copyright 2006 STMicroelecronics                  =");
        SerialPutString("\r\n=                                                                    =");
        SerialPutString("\r\n=     In-Application Programming Application  (Version 3.0)          =");
        SerialPutString("\r\n=                                                                    =");
        SerialPutString("\r\n=                                   By MCD Application Team          =");
        SerialPutString("\r\n======================================================================");
        SerialPutString("\r\n\r\n");
        Main_Menu ();
    }

    else /* Keep the user application running */
    {

        Jump_To_Application = (pFunction) ApplicationAddress;
        Jump_To_Application();
    }

    while (1);
}
/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/
